(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     33753,       1065]
NotebookOptionsPosition[     31019,        982]
NotebookOutlinePosition[     31399,        998]
CellTagsIndexPosition[     31356,        995]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Wright Camera", "Title"],

Cell[TextData[StyleBox["WrightCamera",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["f1",
           FontWeight->Bold], Cell["focal length of the primary mirror"]},
         {Cell["Ni",
           FontWeight->Bold], Cell["refractive index of the lens"]},
         {Cell["thick",
           FontWeight->Bold], Cell[
          "thickness of lenses / thickness of the corrector"]},
         {Cell["diam",
           FontWeight->Bold], Cell["diameter of the primary mirror"]},
         {Cell["\[CapitalDelta]",
           FontWeight->Bold], Cell[
          "distance between the corrector and the mirror"]},
         {Cell["\[Theta]",
           FontWeight->Bold], Cell["field angle in degrees"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[CellGroupData[{

Cell["Interface function", "Subsection"],

Cell[TextData[{
 StyleBox["WrightCameraInputPanel",
  FontWeight->"Bold",
  FontVariations->{"Underline"->True}],
 " (no argument required, it creates a panel to work with the main function \
by means of easy controls and input fields)"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auxiliary function", "Subsection"],

Cell[TextData[StyleBox["TotalAberrations",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["rad",
           FontWeight->Bold], Cell["list of the radii of the surfaces"]},
         {Cell["thick",
           FontWeight->Bold], Cell["\<\
list of the distances between the surfaces along the optical axis\
\>"]},
         {Cell["ind",
           FontWeight->Bold], Cell["list of the refractive indices"]},
         {Cell["costasf",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"list of the constants which characterize the nature of any \
surface\"\>"},
             {"\<\"(0 for a sphere, K for a conic, {a4, as} for an aspheric \
surface)\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["stoprad",
           FontWeight->Bold], Cell["radius of the aperture stop"]},
         {Cell["nstop",
           FontWeight->Bold], Cell["number of the surfaces before the stop"]},
         {Cell["dis",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"if nstop = 0, is the (negative) distance of the aperture \
stop from the first surface after it\"\>"},
             {"\<\"if nstop > 0,  is the distance between the last surface \
before the aperture stop and the aperture stop\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["dobject",
           FontWeight->Bold], Cell[
          "distance of the object from the first surface"]},
         {Cell["hobject",
           FontWeight->Bold], Cell["\<\
height of the object (only if the object is at a finite distance)\
\>"]},
         {Cell["angle",
           FontWeight->Bold], Cell[
          "view angle in degrees (if the object is at infinity)"]},
         {Cell["waves",
           FontWeight->Bold], Cell[
          "the wavelengths of the chosen refractive indices"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]},
         {"\[SpanFromAbove]", Cell["Coefficients"], Cell[
          "gives only aberration coefficients"]},
         {"\[SpanFromAbove]", Cell["None"], Cell["doesn't show any result"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Output variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["GOn",
           FontWeight->Bold], Cell["Number of surface"]},
         {Cell["GOren",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the entrance pupil for \"",SubscriptBox[
            "\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOwen",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Distance of the exit pupil from the last surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOrexit",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the exit pupil for \"",SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOdistancefp",
           FontWeight->Bold], Cell[
          "Distance of the first principal plane from the first surface"]},
         {Cell["GOdistancesp",
           FontWeight->Bold], Cell[
          "Distance of the second principal plane from the last surface"]},
         {Cell["GOdistancegauss",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Gaussian distance of the images from the surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOfocalLength",
           FontWeight->Bold], Cell["Focal length"]},
         {Cell["GOimageHeight",
           FontWeight->Bold], Cell["Image height"]},
         {Cell["GOaberration",
           FontWeight->Bold], Cell["Third-order spherical aberration "]},
         {Cell["GOcoma",
           FontWeight->Bold], Cell["Third-order coma"]},
         {Cell["GOastigmatism",
           FontWeight->Bold], Cell["Third-order astigmatism"]},
         {Cell["GOcurvature",
           FontWeight->Bold], Cell["Third-order total curvature"]},
         {Cell["GOSeidelCurvature",
           FontWeight->Bold], Cell["Third-order curvature coefficient"]},
         {Cell["GOPetzvalRadius",
           FontWeight->Bold], Cell["Petzval radius"]},
         {Cell["GOdistortion",
           FontWeight->Bold], Cell["Third-order distortion"]},
         {Cell["GOSphericalCoefficient",
           FontWeight->Bold], Cell["Spherical Coefficient"]},
         {Cell["GOComaCoefficient",
           FontWeight->Bold], Cell["Coma Coefficient"]},
         {Cell["GOAstigmatismCoefficient",
           FontWeight->Bold], Cell["Astigmatism Coefficient"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Wright Camera", "Title"],

Cell[TextData[{
 "Wright's Camera is an aplanetic combination formed by a Schmidt's corrector \
",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 " and a conic mirror ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 ". It is shorter than a Schmidt's camera but exhibits a sensible \
astigmatism. The design starts from the analysis of the aberrations of a \
conic mirror ",
 Cell[BoxData[
  FormBox[
   RowBox[{"S", ",", " "}], TraditionalForm]]],
 "with the apertur stop ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]]],
 " far apart -",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Delta]", Cell[TextData[Cell[BoxData[
     FormBox["f", TraditionalForm]]]]]}], TraditionalForm]]],
 "from ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 ". (the variables f, K, \[Delta], r, x, \[Theta], \[Lambda] have to be \
unassigned, for that we use Clear)"
}], "Text",
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "f", ",", "K", ",", "\[Delta]", ",", "r", ",", "x", ",", "\[Theta]", ",", 
    "\[Lambda]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rad", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], "f"}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}]}], "}"}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", "K", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"stoprad", "=", "r"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dis", "=", 
   RowBox[{
    RowBox[{"-", "\[Delta]"}], " ", "f"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"angle", "=", "\[Theta]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "\[Lambda]", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "\[Theta]", ",", 
   "waves", ",", " ", 
   RowBox[{"OutputLevel", "\[Rule]", "\"\<Coefficients\>\""}], ",", " ", 
   RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}]}], "]"}]], "Input"],

Cell[TextData[{
 "Now we evaluate the aberrations of Schmidt's corrector ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 ", that is an almost afocal system. Since the first surface of ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 " is planar, the second one has a fourth-order profile, if we neglect the \
effect of its radius of curvature at the vertex, then we have that"
}], "Text",
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"rad", "=", 
    RowBox[{"{", 
     RowBox[{"Infinity", ",", "Infinity"}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", "0", "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "N", ",", "1"}], "}"}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"a4", ",", "as"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"stoprad", "=", "r"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"angle", "=", "\[Theta]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "\[Lambda]", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "\[Theta]", ",", 
   "waves", ",", " ", 
   RowBox[{"OutputLevel", "\[Rule]", "\"\<Coefficients\>\""}], ",", " ", 
   RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}]}], "]"}]], "Input"],

Cell[TextData[{
 "The values of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "4"], " "}], TraditionalForm]]],
 "and ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]]],
 ", that eliminate  spherical aberration and coma, satisfy the system:"
}], "Text",
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"1", "+", "K"}], ")"}]}], "+", 
     RowBox[{"32", 
      SuperscriptBox["f", "3"], "a4", " ", 
      RowBox[{"(", 
       RowBox[{"Ni", "-", "1"}], ")"}]}]}], "\[Equal]", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "K"}], ")"}], " ", "\[Delta]"}]}], ")"}], 
    "\[Equal]", "0"}]}], ";"}], "\n", 
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"eq1", ",", "eq2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a4", ",", "K"}], "}"}]}], "]"}], "]"}], "//", 
   "Simplify"}]}]}], "Input"],

Cell[TextData[{
 "It is interesting to plot the behavior of the astigmatism as a function of \
\[Delta] for these values of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "4"], " "}], TraditionalForm]]],
 "and ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]]],
 ". To this end, we consider the aberration coefficients of the whole \
combination"
}], "Text",
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "f", ",", "K", ",", "\[Delta]", ",", "r", ",", "a4", ",", "as", ",", "x", 
    ",", "\[Theta]", ",", "\[Lambda]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rad", "=", 
    RowBox[{"{", 
     RowBox[{"Infinity", ",", "Infinity", ",", 
      RowBox[{
       RowBox[{"-", "2"}], "f"}]}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"\[Delta]", " ", "f"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "Ni", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"a4", ",", "as"}], "}"}], ",", "K"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"stoprad", "=", "r"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"angle", "=", "\[Theta]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", "\[Lambda]", "}"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "\[Theta]", ",", 
   "waves", ",", " ", 
   RowBox[{"OutputLevel", "\[Rule]", "\"\<Coefficients\>\""}], ",", " ", 
   RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"GOSphericalCoefficient", "/.", "sol"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"GOComaCoefficient", "/.", "sol"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"ast", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"GOastigmatism", "/.", "sol"}], ")"}], "//", "Simplify"}], "//", 
   "Chop"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   FractionBox["ast", 
    RowBox[{"r", " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     SuperscriptBox["\[Theta]", "2"]}]], ",", 
   RowBox[{"{", 
    RowBox[{"\[Delta]", ",", "0.4", ",", "2"}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Wright Camera Summary", "Title"],

Cell[TextData[{
 "Aberration coefficients of the mirror ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 " with the aperture stop ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]]],
 " at a distance ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Delta]", " ", "f", " "}], TraditionalForm]]],
 "from ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 ":"
}], "Text"],

Cell["spherical aberration", "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"DS1", "=", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"32", " ", 
        SuperscriptBox["f", "3"]}]]}], 
     RowBox[{"(", 
      RowBox[{"1", "+", "K"}], ")"}]}]}], ";"}], 
  TraditionalForm]], "DisplayFormula"],

Cell["coma", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DS2", " ", "=", 
   FormBox[
    RowBox[{
     FractionBox["1", 
      RowBox[{"8", " ", 
       SuperscriptBox["f", "2"]}]], 
     RowBox[{"(", 
      RowBox[{"2", "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "K"}], ")"}], "\[Delta]"}]}], ")"}]}],
    TraditionalForm]}], ";"}]], "DisplayFormula"],

Cell[TextData[{
 "Values of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "4"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]]],
 " which eliminate spherical aberration and coma"
}], "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["a", "4"], " ", "=", 
    FractionBox["1", 
     RowBox[{"16", " ", 
      SuperscriptBox[
       SubscriptBox["f", "1"], "3"], " ", 
      RowBox[{"(", 
       RowBox[{"Ni", "-", "1"}], ")"}], "\[Delta]"}]]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"K", "=", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{
      FractionBox["2", "\[Delta]"], ".", "  "}]}]}]}], 
  TraditionalForm]], "DisplayFormula"],

Cell[TextData[{
 "Starting from the above formulae, good results are obtained for speeds of ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 " is less or equal to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "/", "4"}], TraditionalForm]]],
 " and \[Delta]",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[GreaterEqual]", "1.1"}], TraditionalForm]]],
 ". For speeds in the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "/", "4"}], "-", 
    RowBox[{"F", "/", "3"}]}], TraditionalForm]]],
 " , we should"
}], "Text"],

Cell[TextData[{
 "consider the finite value of the curvature radius of the second surface of ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]]
}], "Item"],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["R", "c"], "=", 
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{
      SubscriptBox["a", "4"], 
      SuperscriptBox["\[Alpha]", "2"], 
      SuperscriptBox["r", "2"]}]]}]}], TraditionalForm]], "DisplayFormula"],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", " "}], TraditionalForm]]],
 "is the form factor of the surface and ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]]],
 " the radius of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"A", " "}], TraditionalForm]]],
 "(see Chapter 4);"
}], "Text"],

Cell["balance the third and fifth-order spherical aberrations.", "Item"],

Cell[TextData[{
 "For speed  greater than ",
 Cell[BoxData[
  FormBox[Cell[TextData[{
    Cell[BoxData[
     FormBox[
      RowBox[{"F", "/", "3"}], TraditionalForm]]],
    ","
   }]], TraditionalForm]]],
 " the astigmatism is too high."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["WrightCamera Examples", "Title"],

Cell["\<\
To use the WrightCamera function you can either use directly the function \
WrightCamera[f, Ni, thick, diam, \[CapitalDelta], \[Theta]] or use the \
interactive panel created by calling the function WrightCameraInputPanel[]. \
It let\[CloseCurlyQuote]s you to set input values and then call the \
WrightCamera function. Moreover, it helps to load examples from the saved \
archives and set the output style.
Here are some examples\
\>", "Text"],

Cell["Example of Wright's camera F/3, \[CapitalDelta] = 750", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "=", "600"}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Ni", "=", "1.518722"}], ";"}], 
  RowBox[{"(*", "BK7", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", "8"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "750"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "1.5"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "generates", " ", "a", " ", "new", " ", "notebook", " ", 
    "with", " ", "a", " ", "report", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"WrightCamera", "[", 
   RowBox[{
   "f", ",", "Ni", ",", "thick", ",", "diam", ",", "\[CapitalDelta]", ",", 
    "\[Theta]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "the", 
    " ", "summary", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"WrightCamera", "[", 
   RowBox[{
   "f", ",", "Ni", ",", "thick", ",", "diam", ",", "\[CapitalDelta]", ",", 
    "\[Theta]", ",", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "only", 
    " ", "the", " ", "output", " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"WrightCamera", "[", 
   RowBox[{
   "f", ",", "Ni", ",", "thick", ",", "diam", ",", "\[CapitalDelta]", ",", 
    "\[Theta]", ",", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"this", " ", "gives", " ", 
     RowBox[{"input", "/", "output"}], " ", "values", " ", "as", " ", "a", 
     " ", "Return", " ", "from", " ", "the", " ", "function"}], ",", " ", 
    RowBox[{
    "with", " ", "labels", " ", "for", " ", "each", " ", "variable"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"WrightCamera", "[", 
   RowBox[{
   "f", ",", "Ni", ",", "thick", ",", "diam", ",", "\[CapitalDelta]", ",", 
    "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Basic\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Full\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "this", " ", "gives", " ", "only", " ", "output", " ", "values", " ", 
     "as", " ", "a", " ", "Return", " ", "from", " ", "the", " ", 
     "function"}], ",", " ", 
    RowBox[{"with", " ", "no", " ", "labels", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"useful", " ", "for", " ", "cutting"}], "&"}], "pasting", " ",
        "operations"}], " "}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"WrightCamera", "[", 
   RowBox[{
   "f", ",", "Ni", ",", "thick", ",", "diam", ",", "\[CapitalDelta]", ",", 
    "\[Theta]", ",", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Values\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell["Example of Wright's camera F/3, \[CapitalDelta] = 900", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "=", "600"}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Ni", "=", "1.518722"}], ";"}], 
  RowBox[{"(*", "BK7", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", "8"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "900."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "1.5"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"WrightCamera", "[", 
  RowBox[{
  "f", ",", "Ni", ",", "thick", ",", "diam", ",", "\[CapitalDelta]", ",", 
   "\[Theta]"}], "]"}]], "Input"],

Cell["Load examples from the archive using LoadExample ", "Text"],

Cell[BoxData[
 RowBox[{"LoadExample", "[", "\"\<WrightCamera\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"WrightCamera", "[", "]"}]], "Input"],

Cell["Use the GUI panel to have all parameters under control", "Text"],

Cell[BoxData[
 RowBox[{"WrightCameraInputPanel", "[", "]"}]], "Input"]
}, Open  ]]
},
WindowSize->{1920, 992},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
TrackCellChangeTimes->False,
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"GeometricOptics.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 30, 0, 71, "Title"],
Cell[612, 24, 107, 2, 46, "Text"],
Cell[722, 28, 1685, 44, 303, "Text"],
Cell[2410, 74, 2110, 53, 389, "Text"],
Cell[CellGroupData[{
Cell[4545, 131, 40, 0, 43, "Subsection"],
Cell[4588, 133, 248, 6, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4873, 144, 40, 0, 43, "Subsection"],
Cell[4916, 146, 111, 2, 46, "Text"],
Cell[5030, 150, 3193, 83, 551, "Text"],
Cell[8226, 235, 2296, 56, 473, "Text"],
Cell[10525, 293, 3465, 89, 849, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14039, 388, 30, 0, 71, "Title"],
Cell[14072, 390, 886, 28, 70, "Text"],
Cell[14961, 420, 1212, 42, 275, "Input"],
Cell[16176, 464, 382, 7, 32, "Input"],
Cell[16561, 473, 414, 10, 70, "Text"],
Cell[16978, 485, 1043, 36, 253, "Input"],
Cell[18024, 523, 382, 7, 32, "Input"],
Cell[18409, 532, 285, 11, 50, "Text"],
Cell[18697, 545, 836, 30, 77, "Input"],
Cell[19536, 577, 390, 13, 50, "Text"],
Cell[19929, 592, 1404, 46, 275, "Input"],
Cell[21336, 640, 382, 7, 32, "Input"],
Cell[21721, 649, 108, 2, 32, "Input"],
Cell[21832, 653, 103, 2, 32, "Input"],
Cell[21938, 657, 180, 6, 32, "Input"],
Cell[22121, 665, 422, 12, 51, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22580, 682, 38, 0, 71, "Title"],
Cell[22621, 684, 370, 15, 46, "Text"],
Cell[22994, 701, 36, 0, 46, "Text"],
Cell[23033, 703, 289, 11, 54, "DisplayFormula"],
Cell[23325, 716, 20, 0, 46, "Text"],
Cell[23348, 718, 359, 13, 46, "DisplayFormula"],
Cell[23710, 733, 225, 9, 50, "Text"],
Cell[23938, 744, 482, 17, 106, "DisplayFormula"],
Cell[24423, 763, 533, 19, 46, "Text"],
Cell[24959, 784, 156, 4, 26, "Item"],
Cell[25118, 790, 267, 9, 56, "DisplayFormula"],
Cell[25388, 801, 316, 13, 46, "Text"],
Cell[25707, 816, 72, 0, 26, "Item"],
Cell[25782, 818, 249, 10, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26068, 833, 38, 0, 71, "Title"],
Cell[26109, 835, 454, 8, 94, "Text"],
Cell[26566, 845, 69, 0, 46, "Text"],
Cell[26638, 847, 433, 15, 143, "Input"],
Cell[27074, 864, 437, 11, 55, "Input"],
Cell[27514, 877, 484, 12, 55, "Input"],
Cell[28001, 891, 511, 12, 55, "Input"],
Cell[28515, 905, 666, 15, 55, "Input"],
Cell[29184, 922, 780, 19, 55, "Input"],
Cell[29967, 943, 69, 0, 46, "Text"],
Cell[30039, 945, 434, 15, 143, "Input"],
Cell[30476, 962, 164, 4, 32, "Input"],
Cell[30643, 968, 65, 0, 46, "Text"],
Cell[30711, 970, 83, 1, 32, "Input"],
Cell[30797, 973, 60, 1, 32, "Input"],
Cell[30860, 976, 70, 0, 46, "Text"],
Cell[30933, 978, 70, 1, 32, "Input"]
}, Open  ]]
}
]
*)

